install.packages("ggplot2")
library("ggplot2")
install.packages("ggpubr")
library("ggpubr")
install.packages("gridExtra")
library("gridExtra")

#Data copied from Excel put into a vector for each measure
countries <- c("RU","KZ","SI","DE","HU","ES","CH","AT","TR","KR")

powerlessness <- c(71.8,60.7,82,74.1,27.6,73.3,51.8,54.6,77.7,43.3)
social_isolation <- c(30.9,24.8,16.3,17.5,23.4,26.6,12.4,10,48.9,48.7)
meaninglessness <- c(44.4,41.3,22.6,20.5,31.4,23.9,11.9,10.2,58.9,43)
normlessness <- c(66.7,66.1,48.2,29.7,82.5,26.9,20,22.1,38.4,26.2)
job_dissatisfaction <- c(26.3,30.7,22,16.8,17.5,21.6,9.1,9.6,46.1,42.6)
datasetval <- c(10,10,19,19,19,19,19,19,19,19)

#Online source here gives an example for grouped barplots:
#https://intellipaat.com/community/16343/how-to-put-labels-over-geombar-for-each-bar-in-r-with-ggplot2
#It works the same way for scatterplots, one has to include "geom_point()" instead of "geom_bar"
#The function "theme()" can be used to change design aspects. Here the x and y axis ticks and their lables as well as the y axis label were hidden and the background colour and grid colour changed.
#in the example provided the "geom_text()" command was used to write the respective values over the points/bars. For the current case this was removed
#"scale_y_continuous" can be used to format the y axis in terms of beginning, end and steps inbetween.
#with "labs" an x axis label was added
#this will be done for each plot individually and later they will be plottet in the same plot via the "ggarrange" function of the package "ggpubr"

#Colour codes and commands overview:
#http://www.cookbook-r.com/Graphs/Colors_(ggplot2)/

#How to assigns them manually using "scale_color_manual()"
#http://www.sthda.com/english/wiki/ggplot2-colors-how-to-change-colors-automatically-and-manually

#How to change the order in which the countries are displayed manually:
#https://stackoverflow.com/questions/12075037/ggplot-legends-change-labels-order-and-title

#Application here:
countries<- factor(countries, levels=c("RU","KZ","SI","DE","HU","ES","CH","AT","TR","KR"), labels=c("RU","KZ","SI","DE","HU","ES","CH","AT","TR","KR"))

#How to change the order of items in the legend:
#http://www.cookbook-r.com/Graphs/Legends_(ggplot2)/

mycolors <- c("blue", "#CC6600","#FFCC00", "steelblue","green","purple","brown","#666666", "red","black")

mydf <- cbind.data.frame(countries,powerlessness,social_isolation,meaninglessness,normlessness,job_dissatisfaction,datasetval)

#Individual Plot Powerlessness
Plot_powerlessness <- ggplot(data=NULL, aes(x=countries, y=powerlessness, fill=countries)) + 
  geom_point(aes(colour = countries),size = 5, shape=mydf$datasetval) + theme(axis.text.x=element_blank(),axis.ticks.x=element_blank(),axis.title.y=element_blank(),
                                                        panel.background = element_rect(fill = "white", colour = "white", size = 2, linetype = "solid"),
                                                        panel.grid.major = element_line(size = 0.5, linetype = 'solid', colour = "grey"), 
                                                        panel.grid.minor = element_line(size = 0.25, linetype = 'solid', colour = "grey")) + 
  scale_y_continuous(breaks = seq(0, 100, by = 10), limits = c(0, 100)) + labs(x="powerlessness")

Plot_powerlessness <- Plot_powerlessness +scale_color_manual(name="countries", labels=c("RU","KZ","SI","DE","HU","ES","CH","AT","TR","KR"), values=c("blue", "#CC6600","#FFCC00", "steelblue","green","purple","brown","#666666", "red","black"))+
  guides(fill = guide_legend(override.aes = list(shape = c(10,10,19,19,19,19,19,19,19,19),colour=c("blue", "#CC6600","#FFCC00", "steelblue","green","purple","brown","#666666", "red","black"),name="Countries")))

print(Plot_powerlessness)

#Individual Plot Social_isolation
Plot_social_isolation <- ggplot(data=NULL, aes(x=countries, y=social_isolation, fill=countries)) + 
  geom_point(aes(colour = countries), size = 5, shape=mydf$datasetval)  + theme(axis.text.x=element_blank(),axis.ticks.x=element_blank(),axis.title.y=element_blank(),
                                                         panel.background = element_rect(fill = "white", colour = "white", size = 2, linetype = "solid"),
                                                         panel.grid.major = element_line(size = 0.5, linetype = 'solid', colour = "grey"), 
                                                         panel.grid.minor = element_line(size = 0.25, linetype = 'solid', colour = "grey")) + 
  scale_y_continuous(breaks = seq(0, 100, by = 10), limits = c(0, 100)) + labs(x="social isolation")

Plot_social_isolation <- Plot_social_isolation + scale_color_manual(name="countries", labels=c("RU","KZ","SI","DE","HU","ES","CH","AT","TR","KR"), values=c("blue", "#CC6600","#FFCC00", "steelblue","green","purple","brown","#666666", "red","black"))+
  guides(fill = guide_legend(override.aes = list(shape = c(10,10,19,19,19,19,19,19,19,19),colour=c("blue", "#CC6600","#FFCC00", "steelblue","green","purple","brown","#666666", "red","black"),name="Countries")))

print(Plot_social_isolation)


# Individual Plot Meaninglessness
Plot_meaninglessness <- ggplot(data=NULL, aes(x=countries, y=meaninglessness, fill=countries)) + 
  geom_point(aes(colour = countries), size = 5, shape=mydf$datasetval) + theme(axis.text.x=element_blank(),axis.ticks.x=element_blank(),axis.title.y=element_blank(),
                                                        panel.background = element_rect(fill = "white", colour = "white", size = 2, linetype = "solid"),
                                                        panel.grid.major = element_line(size = 0.5, linetype = 'solid', colour = "grey"), 
                                                        panel.grid.minor = element_line(size = 0.25, linetype = 'solid', colour = "grey")) + 
  scale_y_continuous(breaks = seq(0, 100, by = 10), limits = c(0, 100)) + labs(x="meaninglessness")

Plot_meaninglessness <- Plot_meaninglessness + scale_color_manual(name="countries", labels=c("RU","KZ","SI","DE","HU","ES","CH","AT","TR","KR"), values=c("blue", "#CC6600","#FFCC00", "steelblue","green","purple","brown","#666666", "red","black"))+
  guides(fill = guide_legend(override.aes = list(shape = c(10,10,19,19,19,19,19,19,19,19),colour=c("blue", "#CC6600","#FFCC00", "steelblue","green","purple","brown","#666666", "red","black"),name="Countries")))

print(Plot_meaninglessness)



# Individual Plot Normlessness
Plot_normlessness <- ggplot(data=NULL, aes(x=countries, y=normlessness, fill=countries)) + 
  geom_point(aes(colour = countries), size = 5, shape=mydf$datasetval) + theme(axis.text.x=element_blank(),axis.ticks.x=element_blank(),axis.title.y=element_blank(),
                                                        panel.background = element_rect(fill = "white", colour = "white", size = 2, linetype = "solid"),
                                                        panel.grid.major = element_line(size = 0.5, linetype = 'solid', colour = "grey"), 
                                                        panel.grid.minor = element_line(size = 0.25, linetype = 'solid', colour = "grey")) + 
  scale_y_continuous(breaks = seq(0, 100, by = 10), limits = c(0, 100)) + labs(x="normlessness")

Plot_normlessness <- Plot_normlessness + scale_color_manual(name="countries", labels=c("RU","KZ","SI","DE","HU","ES","CH","AT","TR","KR"), values=c("blue", "#CC6600","#FFCC00", "steelblue","green","purple","brown","#666666", "red","black"))+
  guides(fill = guide_legend(override.aes = list(shape = c(10,10,19,19,19,19,19,19,19,19),colour=c("blue", "#CC6600","#FFCC00", "steelblue","green","purple","brown","#666666", "red","black"),name="Countries")))

print(Plot_normlessness)


# Individual Plot Job dissatisfaction
Plot_job_dissatisfaction <- ggplot(data=NULL, aes(x=countries, y=job_dissatisfaction, fill=countries)) + 
  geom_point(aes(colour = countries), size = 5, shape=mydf$datasetval) + theme(axis.text.x=element_blank(),axis.ticks.x=element_blank(),axis.title.y=element_blank(),
                                                        panel.background = element_rect(fill = "white", colour = "white", size = 2, linetype = "solid"),
                                                        panel.grid.major = element_line(size = 0.5, linetype = 'solid', colour = "grey"), 
                                                        panel.grid.minor = element_line(size = 0.25, linetype = 'solid', colour = "grey")) + 
  scale_y_continuous(breaks = seq(0, 100, by = 10), limits = c(0, 100)) + labs(x="job dissatisfaction")

Plot_job_dissatisfaction <- Plot_job_dissatisfaction + scale_color_manual(name="countries", labels=c("RU","KZ","SI","DE","HU","ES","CH","AT","TR","KR"), values=c("blue", "#CC6600","#FFCC00", "steelblue","green","purple","brown","#666666", "red","black"))+
  guides(fill = guide_legend(override.aes = list(shape = c(10,10,19,19,19,19,19,19,19,19),colour=c("blue", "#CC6600","#FFCC00", "steelblue","green","purple","brown","#666666", "red","black"),name="Countries")))

print(Plot_job_dissatisfaction)

#Combining the individual plots into one plot
ggarrange(Plot_powerlessness, Plot_social_isolation,Plot_meaninglessness,Plot_normlessness,Plot_job_dissatisfaction, ncol=5, nrow=1, common.legend = TRUE, legend="bottom")
